set more off
pause off

/**********************************************************************
* Cheaper Faster and More than Good Enough: 
Is GPS the New Gold Standard in Land Area Measurement -- SRM

// Syntax for table construction		

***********************************************************************/

global mlass 	"$et_data/CheaperFaster_Ethiopia.dta"
global zanzi	"$zanzi/CheaperFaster_Zanzibar.dta"
global nigeria	"$nga_data/CheaperFaster_Nigeria.dta"
global all_exp	"all_aggregate.dta"

global table 	/*"$main\Tables & Figures\Descriptives_7.22b.xlsx"*/
putexcel set 	"$table", modify keepcellform

/*****************************************************
**						Tables						**
******************************************************

Table 1: Determinants of Closing Error	

Table 2: SR vs CR

Table 3: GPS vs CR

Table 4: Correlations (GPS & CR)

Table 5: Descriptives of High Bias

Table 6: Determinants of Bias (SR - CR)

Table 7: Standard and Non-Standard Units	

Table 8: Determinants of Bias (GPS - CR)

Table 9: Determinants of High Bias

Table A1: Summary Statistics on Weather Conditions, Satellites, & Canopy Cover

*****************************************************/



//Table 1: Determinants of Closing Error
use "$mlass", clear
		
	gen pa_cr=cr_perimeter/CRarea
	gen pa_gps=gps_perimeter/GPSarea
				replace pa_gps=pa_cr if pa_gps==. 

	reg closingerr CR_acres CR2 CR3 num_corners slope_clin i.treecover i.weather2, robust
	estimates store mlass_nofe
	
	
use "$zanzi", clear
	
	gen pa_cr=cr_perimeter/CRarea
	gen pa_gps=gps_perimeter/GPSarea
			replace pa_gps=pa_cr if pa_gps==. 
				
	reg closingerr CR_acres  num_corners i.treecover i.weather2, robust
	estimates store zanzi_nofe

use "$nigeria", clear
	
	gen pa_cr=cr_perimeter/CRarea
	gen pa_gps=gps_perimeter/GPSarea
				replace pa_gps=pa_cr if pa_gps==. 
				
	reg closingerr CR_acres CR2 num_corners i.treecover i.weather2, robust
	estimates store nigeria_nofe


use "$all_exp", clear
	
	gen pa_cr=cr_perimeter/CRarea
	gen pa_gps=gps_perimeter/GPSarea
		replace pa_gps=pa_cr if pa_gps==. // 0 changes
				
	reg closingerr CR_acres  num_corners i.treecover i.weather2, robust
	estimates store pool_nofe
	
	estimates table mlass_nofe  zanzi_nofe  nigeria_nofe  pool_nofe ,  stats(N r2) star(.10 .05 .01) b(%7.3f)
	

//Table 2: SR vs CR

	foreach file in mlass zanzi nigeria all_exp {
	//all levels
	use "$`file'", clear 
	drop if SR_acres==. | CR_acres==.
	gen bias_sr_cr=SR_acres-CR_acres
	
	forvalues i=1(1)6{
	mean SR_acres CR_acres bias_sr_cr if level_cr_acres==`i'
	matrix define LEVEL`i' = e(b)'
	}
		mean SR_acres CR_acres bias_sr_cr
		matrix define LEVEL_TOT = e(b)'

		matrix define LEVEL = LEVEL1,LEVEL2,LEVEL3,LEVEL4,LEVEL5,LEVEL6,LEVEL_TOT
		matrix `file'=LEVEL'

		matrix colnames `file' = SR CR BIAS
		matrix rownames `file' = 1 2 3 4 5 6 Total

		matrix list `file'

	}
		putexcel D146=matrix(mlass) I146=matrix(zanzi) N146=matrix(nigeria) S146=matrix(all_exp) D29=matrix(malawi) I29=matrix(tanzania), sheet("Sheet 1") 

			//For N
			use "$mlass", clear
			drop if SR_acres==. | CR_acres==.
			tab level_cr_acres, matcell(N)
			putexcel C146=matrix(N) , sheet("Sheet 1") 
		
			use "$zanzi", clear
			drop if SR_acres==. | CR_acres==.
			tab level_cr_acres, matcell(N)
			putexcel H146=matrix(N) , sheet("Sheet 1") 
			
			use "$nigeria", clear
			drop if SR_acres==. | CR_acres==.
			tab level_cr_acres, matcell(N)
			putexcel M146=matrix(N) , sheet("Sheet 1") 
							
			use "$all_exp", clear
			drop if SR_acres==. | CR_acres==.
			tab level_cr_acres, matcell(N)
			putexcel R146=matrix(N) , sheet("Sheet 1") 



//Table 3: GPS vs CR

foreach file in mlass zanzi nigeria all_exp {

	use "$`file'", clear 

	forvalues i=1(1)6{
	mean GPS_acres CR_acres bias_cr if level_cr_acres==`i'
	matrix define LEVEL`i' = e(b)'
	}
	
	mean GPS_acres CR_acres bias_cr
	matrix define LEVEL_TOT = e(b)'
		
		matrix define LEVEL = LEVEL1,LEVEL2,LEVEL3,LEVEL4,LEVEL5,LEVEL6,LEVEL_TOT
		matrix `file'=LEVEL'

		matrix colnames `file' = GPS CR BIAS
		matrix rownames `file' = 1 2 3 4 5 6 TOTAL 

		matrix list `file'
}

		putexcel D6=matrix(mlass) I6=matrix(zanzi) N6=matrix(nigeria) S6=matrix(all_exp), sheet("Sheet 1") 

			//For N
			use "$mlass", clear
			tab level_cr_acres, matcell(N)
			putexcel C6=matrix(N) , sheet("Sheet 1") 
		
			use "$zanzi", clear
			tab level_cr_acres, matcell(N)
			putexcel H6=matrix(N) , sheet("Sheet 1") 
			
			use "$nigeria", clear
			tab level_cr_acres, matcell(N)
			putexcel M6=matrix(N) , sheet("Sheet 1") 
			
			use "$all_exp", clear
			tab level_cr_acres, matcell(N)
			putexcel R6=matrix(N) , sheet("Sheet 1") 

			

//Table 4: Correlations (GPS & CR)
foreach file in mlass zanzi all_exp {

	use "$`file'", clear 
	drop if CR_acres==. | GPS_acres==.
	
	forvalues i=1(1)6{
	corr GPS_acres CR_acres if level_cr_acres==`i'
	matrix define LEVEL`i' = r(rho)
	}
		corr GPS_acres CR_acres
		matrix define LEVEL_TOT = r(rho)

		matrix define LEVEL = LEVEL1,LEVEL2,LEVEL3,LEVEL4,LEVEL5,LEVEL6, LEVEL_TOT
		matrix `file'=LEVEL'

		matrix colnames `file' = CORR
		matrix rownames `file' = 1 2 3 4 5 6 Total

		matrix list `file'
}
	
		//Nigeria - exclude levels 1 
		use "$nigeria", clear 
	
		forvalues i=2(1)6{
		corr GPS_acres CR_acres if level_cr_acres==`i'
		matrix define LEVEL`i' = r(rho)
		}
		corr GPS_acres CR_acres
		matrix define LEVEL_TOT = r(rho)

		matrix define LEVEL =LEVEL2,LEVEL3,LEVEL4,LEVEL5,LEVEL6, LEVEL_TOT
		matrix nigeria=LEVEL'

		matrix colnames nigeria = CORR
		matrix rownames nigeria = 2 3 4 5 6 Total

		matrix list nigeria
		
		putexcel C18=matrix(mlass) D18=matrix(zanzi) E19=matrix(nigeria) F18=matrix(all_exp), sheet("Sheet 2") 

				
	
//Table 5: Descriptives of High Bias

	set more off
	foreach file in mlass zanzi nigeria all_exp {

	use "$`file'", clear 
	
	gen pa_cr=cr_perimeter/CRarea
	gen pa_gps=gps_perimeter/GPSarea
				replace pa_gps=pa_cr if pa_gps==. // 0 changes
	gen highbias=(per_bias_cr>10 | per_bias_cr<-10)
	gen highbias_over=(highbias==1 & (GPS_acre>CR_acre))
	gen highbias_under=(highbias==1 & (GPS_acre<CR_acre))
	
	mean CR_acres GPS_acres bias_cr abs_per_cr closingerr num_corners  pa_gps   if highbias==1
	matrix define `file'_high = e(b)'

	mean CR_acres GPS_acres bias_cr abs_per_cr closingerr num_corners  pa_gps   if highbias_over==1
	matrix define `file'_over = e(b)'
	
	mean CR_acres GPS_acres bias_cr abs_per_cr closingerr num_corners  pa_gps   if highbias_under==1
	matrix define `file'_under = e(b)'
	
	mean CR_acres GPS_acres bias_cr abs_per_cr closingerr num_corners  pa_gps   if highbias==0
	matrix define `file'_low = e(b)'

	mean CR_acres GPS_acres bias_cr abs_per_cr closingerr num_corners  pa_gps  
	matrix define `file'_all = e(b)'

		matrix define `file' = `file'_high,`file'_over,`file'_under,`file'_low,`file'_all

		matrix colnames `file' = High Over Under Low All   
		matrix rownames `file' = CR GPS Bias Abs_Per CE Corner PA

		matrix list `file'
}
		putexcel T12=matrix(all_exp) C12=matrix(mlass) I12=matrix(zanzi) O12=matrix(nigeria), sheet("HighBias") 
	
	use "$mlass", clear
	gen highbias=(per_bias_cr>10 | per_bias_cr<-10)
	gen highbias_over=(highbias==1 & (GPS_acre>CR_acre))
	gen highbias_under=(highbias==1 & (GPS_acre<CR_acre))
		*frequency
		tab highbias if highbias==1
		putexcel C8=(r(N)), sheet("HighBias")
		tab highbias_over if highbias_over==1
		putexcel D8=(r(N)), sheet("HighBias")
		tab highbias_under if highbias_under==1
		putexcel E8=(r(N)), sheet("HighBias")
		tab highbias if highbias==0
		putexcel F8=(r(N)), sheet("HighBias")
		tab highbias 
		putexcel G8=(r(N)), sheet("HighBias")
		*by treecover
		count if treecover==2 & highbias==1
			putexcel C23=(r(N)), sheet("HighBias")
		count if treecover==2 & highbias_over==1
			putexcel D23=(r(N))	, sheet("HighBias")
		count if treecover==2 & highbias_under==1
			putexcel E23=(r(N))	, sheet("HighBias")
		count if treecover==2 & highbias==0
			putexcel F23=(r(N)), sheet("HighBias")
		count if treecover==2 
			putexcel G23=(r(N))	, sheet("HighBias")
		count if treecover==3 & highbias==1
			putexcel C25=(r(N)), sheet("HighBias")
		count if treecover==3 & highbias_over==1
			putexcel D25=(r(N))	, sheet("HighBias")
		count if treecover==3 & highbias_under==1
			putexcel E25=(r(N))	, sheet("HighBias")
		count if treecover==3 & highbias==0
			putexcel F25=(r(N)), sheet("HighBias")
		count if treecover==3 
			putexcel G25=(r(N))	, sheet("HighBias")
		
	use "$zanzi", clear
	gen highbias=(per_bias_cr>10 | per_bias_cr<-10)
	gen highbias_over=(highbias==1 & (GPS_acre>CR_acre))
	gen highbias_under=(highbias==1 & (GPS_acre<CR_acre))
		tab highbias if highbias==1
		putexcel I8=(r(N)), sheet("HighBias")
		tab highbias_over if highbias_over==1
		putexcel J8=(r(N)), sheet("HighBias")
		tab highbias_under if highbias_under==1
		putexcel K8=(r(N)), sheet("HighBias")
		tab highbias if highbias==0
		putexcel L8=(r(N)), sheet("HighBias")
		tab highbias 
		putexcel M8=(r(N)), sheet("HighBias")
		*by treecover
		count if treecover==2 & highbias==1
			putexcel I23=(r(N)), sheet("HighBias")
		count if treecover==2 & highbias_over==1
			putexcel J23=(r(N))	, sheet("HighBias")
		count if treecover==2 & highbias_under==1
			putexcel K23=(r(N))	, sheet("HighBias")
		count if treecover==2 & highbias==0
			putexcel L23=(r(N)), sheet("HighBias")
		count if treecover==2 
			putexcel M23=(r(N))	, sheet("HighBias")
		count if treecover==3 & highbias==1
			putexcel I25=(r(N)), sheet("HighBias")
		count if treecover==3 & highbias_over==1
			putexcel J25=(r(N))	, sheet("HighBias")
		count if treecover==3 & highbias_under==1
			putexcel K25=(r(N))	, sheet("HighBias")
		count if treecover==3 & highbias==0
			putexcel L25=(r(N)), sheet("HighBias")
		count if treecover==3 
			putexcel M25=(r(N))	, sheet("HighBias")
		
	use "$nigeria", clear
	gen highbias=(per_bias_cr>10 | per_bias_cr<-10)
	gen highbias_over=(highbias==1 & (GPS_acre>CR_acre))
	gen highbias_under=(highbias==1 & (GPS_acre<CR_acre))
		tab highbias if highbias==1
		putexcel O8=(r(N)), sheet("HighBias")
		tab highbias_over if highbias_over==1
		putexcel P8=(r(N)), sheet("HighBias")
		tab highbias_under if highbias_under==1
		putexcel Q8=(r(N)), sheet("HighBias")
		tab highbias if highbias==0
		putexcel R8=(r(N)), sheet("HighBias")
		tab highbias 
		putexcel S8=(r(N)), sheet("HighBias")
		*by treecover
		count if treecover==2 & highbias==1
			putexcel O23=(r(N)), sheet("HighBias")
		count if treecover==2 & highbias_over==1
			putexcel P23=(r(N))	, sheet("HighBias")
		count if treecover==2 & highbias_under==1
			putexcel Q23=(r(N))	, sheet("HighBias")
		count if treecover==2 & highbias==0
			putexcel R23=(r(N)), sheet("HighBias")
		count if treecover==2 
			putexcel S23=(r(N))	, sheet("HighBias")
		count if treecover==3 & highbias==1
			putexcel O25=(r(N)), sheet("HighBias")
		count if treecover==3 & highbias_over==1
			putexcel P25=(r(N))	, sheet("HighBias")
		count if treecover==3 & highbias_under==1
			putexcel Q25=(r(N))	, sheet("HighBias")
		count if treecover==3 & highbias==0
			putexcel R25=(r(N)), sheet("HighBias")
		count if treecover==3 
			putexcel S25=(r(N))	, sheet("HighBias")
		
	use "$all_exp", clear
	gen highbias=(per_bias_cr>10 | per_bias_cr<-10)
	gen highbias_over=(highbias==1 & (GPS_acre>CR_acre))
	gen highbias_under=(highbias==1 & (GPS_acre<CR_acre))
		tab highbias if highbias==1
		putexcel T8=(r(N)), sheet("HighBias")
		tab highbias_over if highbias_over==1
		putexcel U8=(r(N)), sheet("HighBias")
		tab highbias_under if highbias_under==1
		putexcel V8=(r(N)), sheet("HighBias")
		tab highbias if highbias==0
		putexcel W8=(r(N)), sheet("HighBias")
		tab highbias 
		putexcel X8=(r(N)), sheet("HighBias")
		*by treecover
		count if treecover==2 & highbias==1
			putexcel T23=(r(N)), sheet("HighBias")
		count if treecover==2 & highbias_over==1
			putexcel U23=(r(N))	, sheet("HighBias")
		count if treecover==2 & highbias_under==1
			putexcel V23=(r(N))	, sheet("HighBias")
		count if treecover==2 & highbias==0
			putexcel W23=(r(N)), sheet("HighBias")
		count if treecover==2 
			putexcel X23=(r(N))	, sheet("HighBias")
		count if treecover==3 & highbias==1
			putexcel T25=(r(N)), sheet("HighBias")
		count if treecover==3 & highbias_over==1
			putexcel U25=(r(N))	, sheet("HighBias")
		count if treecover==3 & highbias_under==1
			putexcel V25=(r(N))	, sheet("HighBias")
		count if treecover==3 & highbias==0
			putexcel W25=(r(N)), sheet("HighBias")
		count if treecover==3 
			putexcel X25=(r(N))	, sheet("HighBias")		
		
	use "$all_exp", clear
		gen highbias=(per_bias_cr>10 | per_bias_cr<-10)
		gen highbias_over=(highbias==1 & (GPS_acre>CR_acre))
		gen highbias_under=(highbias==1 & (GPS_acre<CR_acre))
		
		*High bias by CE
		bysort survey: sum highbias highbias_over highbias_under if closingerr>4
		bysort survey: sum highbias highbias_over highbias_under if closingerr<=4
		bysort survey: sum highbias highbias_over highbias_under if closingerr<=3
		bysort survey: sum highbias highbias_over highbias_under if closingerr<=2
		bysort survey: sum highbias highbias_over highbias_under if closingerr<=1
			
		bysort survey: sum num_satel if highbias==1
		bysort survey: sum num_satel if highbias_over==1
		bysort survey: sum num_satel if highbias_under==1
		bysort survey: sum num_satel if highbias==0
		bysort survey: sum num_satel 

		sum zs_slp_mean if highbias==1
		sum zs_slp_mean if highbias_over==1
		sum zs_slp_mean if highbias_under==1
		sum zs_slp_mean if highbias==0
		sum zs_slp_mean 
		
		sum walk_speed if highbias==1
		sum walk_speed if highbias_over==1
		sum walk_speed if highbias_under==1
		sum walk_speed if highbias==0
		sum walk_speed 
		
			tab highbias if closingerr>4
			tab highbias_over  if closingerr>4
			tab highbias_under if closingerr>4
		
			tab highbias if closingerr<=4
			tab highbias_over  if closingerr<=4
			tab highbias_under if closingerr<=4
			
			tab highbias if closingerr<=3
			tab highbias_over  if closingerr<=3
			tab highbias_under if closingerr<=3
			
			tab highbias if closingerr<=2
			tab highbias_over  if closingerr<=2
			tab highbias_under if closingerr<=2
			
			tab highbias if closingerr<=1
			tab highbias_over  if closingerr<=1
			tab highbias_under if closingerr<=1
			
			*High bias by Plot Size
		bysort survey: sum highbias highbias_over highbias_under if level_cr_acres==1
		bysort survey: sum highbias highbias_over highbias_under if level_cr_acres==2
		bysort survey: sum highbias highbias_over highbias_under if level_cr_acres==3
		bysort survey: sum highbias highbias_over highbias_under if level_cr_acres==4
		bysort survey: sum highbias highbias_over highbias_under if level_cr_acres==5
		bysort survey: sum highbias highbias_over highbias_under if level_cr_acres==6
		bysort level_cr_acres: sum highbias highbias_over highbias_under
		

//Table 6: Determinants of Bias (SR - CR) 

use "$mlass", clear
replace cashcrop_1=0 if cashcrop_1==. // 4 obs
replace cashcrop_2=0 if cashcrop_2==. // 4 obs
drop if SR_acres==. | CR_acres==.
gen bias_sr_cr=SR_acres-CR_acres
	gen absbias=abs(bias_sr_cr)
	gen per=(bias_sr_cr/CR_acre)*100
	gen abs_per_sc=(absbias/CR_acre)*100
	gen pa_cr=cr_perimeter/CRarea
	gen pa_gps=gps_perimeter/GPSarea
			replace pa_gps=pa_cr if pa_gps==. 
	gen prop=(title==1 | collateral==1)
	
	reg bias_sr_cr CR_acres CR2 CR3 num_corners dist_home num_cult_fields cashcrop_1 slope_clin i.soilqual_sr prop i.treecover head_female head_yr head_age, robust
	estimates store mlass_bias
	reg absbias CR_acres num_corners dist_home num_cult_fields cashcrop_1  slope_clin i.soilqual_sr prop i.treecover head_female head_yr head_age, robust
	estimates store mlass_absbias	
	reg abs_per_sc CR_acres CR2 CR3 num_corners dist_home num_cult_fields cashcrop_1 slope_clin i.soilqual_sr prop i.treecover head_female head_yr head_age, robust
	estimates store mlass_absperbias
	reg per CR_acres CR2 CR3 num_corners dist_home num_cult_fields cashcrop_1  slope_clin i.soilqual_sr prop i.treecover head_female head_yr head_age, robust
	estimates store mlass_perbias

	estimates table mlass_bias mlass_absbias mlass_perbias mlass_absperbias, stats(N r2) star(.10 .05 .01) b(%7.3f) 
	
use "/Users/sydneygourlay1/Box Sync/Land Sourcebook/Data/all_aggregate_stata12.dta", clear
keep if survey==2
drop if SR_acres==. | CR_acres==.
gen bias_sr_cr=SR_acres-CR_acres
	gen absbias=abs(bias_sr_cr)
	gen abs_per_sc=(absbias/CR_acre)*100
	gen per=(bias_sr_cr/CR_acre)*100
	gen pa_cr=cr_perimeter/CRarea
	gen pa_gps=gps_perimeter/GPSarea
			replace pa_gps=pa_cr if pa_gps==. 

	reg bias_sr_cr CR_acres num_corners dist_home num_cult_fields  i.soilqual_sr prop i.treecover head_female head_yr head_age, robust
	estimates store zanzi_bias
	reg absbias CR_acres CR2 CR3 num_corners dist_home num_cult_fields  i.soilqual_sr prop i.treecover head_female head_yr head_age, robust
	estimates store zanzi_absbias	
	reg abs_per_sc CR_acres CR2 CR3 num_corners dist_home num_cult_fields  i.soilqual_sr prop i.treecover head_female head_yr head_age, robust
	estimates store zanzi_absperbias
	reg per CR_acres CR2 CR3 num_corners dist_home num_cult_fields  i.soilqual_sr prop i.treecover head_female head_yr head_age, robust
	estimates store zanzi_perbias
	
	estimates table zanzi_bias zanzi_absbias zanzi_perbias zanzi_absperbias, stats(N r2) star(.10 .05 .01) b(%7.3f) 
	
use "$nigeria", clear
replace cashcrop_1=0 if cashcrop_1==. // 11 obs
drop if SR_acres==. | CR_acres==.
gen bias_sr_cr=SR_acres-CR_acres
	gen absbias=abs(bias_sr_cr)
	gen abs_per_sc=(absbias/CR_acre)*100
	gen per=(bias_sr_cr/CR_acre)*100
	gen pa_cr=cr_perimeter/CRarea
	gen pa_gps=gps_perimeter/GPSarea
			replace pa_gps=pa_cr if pa_gps==. 
	gen prop=(title==1 | collateral==1)

	reg bias_sr_cr CR_acres CR2 CR3 num_corners num_cult_fields cashcrop_1  prop i.treecover head_female head_yr head_age, robust
	estimates store nigeria_bias
	reg absbias CR_acres CR2 num_corners num_cult_fields cashcrop_1  prop i.treecover head_female head_yr head_age, robust
	estimates store nigeria_absbias	
	reg abs_per_sc CR_acres CR2 num_corners num_cult_fields cashcrop_1  prop i.treecover head_female head_yr head_age, robust
	estimates store nigeria_absperbias
	reg per CR_acres CR2 num_corners num_cult_fields cashcrop_1  prop i.treecover head_female head_yr head_age, robust
	estimates store nigeria_perbias
	
	estimates table nigeria_bias nigeria_absbias nigeria_perbias nigeria_absperbias, stats(N r2) star(.10 .05 .01) b(%7.3f)

	use "/Users/sydneygourlay1/Box Sync/Land Sourcebook/Data/all_aggregate_stata12.dta", clear
	drop if SR_acres==. | CR_acres==.
	gen bias_sr_cr=SR_acres-CR_acres
	gen absbias=abs(bias_sr_cr)
	gen abs_per_sc=(absbias/CR_acre)*100
	gen per=(bias_sr_cr/CR_acre)*100
	gen pa_cr=cr_perimeter/CRarea
	gen pa_gps=gps_perimeter/GPSarea
			replace pa_gps=pa_cr if pa_gps==. 
	drop prop // in zanzibar data only
	gen prop=(title==1 | collateral==1)

	reg bias_sr_cr CR_acres CR2 CR3 num_corners num_cult_fields prop i.treecover head_female head_yr head_age i.survey, robust
	estimates store pooled_bias2
	reg absbias CR_acres CR2 num_corners num_cult_fields prop i.treecover head_female head_yr head_age i.survey, robust
	estimates store pooled_absbias2	
	reg abs_per_sc CR_acres CR2 CR3 num_corners num_cult_fields prop i.treecover head_female head_yr head_age i.survey, robust
	estimates store pooled_absperbias2
	reg per CR_acres CR2 CR3 num_corners num_cult_fields prop i.treecover head_female head_yr head_age i.survey, robust
	estimates store pooled_perbias2
	
	estimates table pooled_bias2 pooled_absbias2 pooled_perbias2 pooled_absperbias2, stats(N r2) star(.10 .05 .01) b(%7.3f)

// Table 7: Standard and Non-Standard Units	
	
	*Nigeria had no standard units in levels 1 & 2
	use "$mlass", clear 
	drop if bias_gps==. 

	forvalues i=1(1)2{
	mean SR_acres GPS_acres bias_gps if level_gps_acres==`i' & standard_unit==1
	matrix define LEVEL`i'_s = e(b)'
	mean SR_acres GPS_acres bias_gps if level_gps_acres==`i' & standard_unit==0
	matrix define LEVEL`i'_ns = e(b)'
	}
		
		matrix define LEVEL_s = LEVEL1_s,LEVEL2_s
		matrix mlass12_s=LEVEL_s'

		matrix colnames mlass12_s = SR GPS Bias 
		matrix rownames mlass12_s = 1 2 

		matrix list mlass12_s

		matrix define LEVEL_ns = LEVEL1_ns,LEVEL2_ns
		matrix mlass12_ns=LEVEL_ns'

		matrix colnames mlass12_ns = SR GPS Bias 
		matrix rownames mlass12_ns = 1 2 

		matrix list mlass12_ns

	use "$nigeria", clear 
	drop if bias_gps==. 

	forvalues i=1(1)2{
	mean SR_acres GPS_acres bias_gps if level_gps_acres==`i' & standard_unit==0
	matrix define LEVEL`i'_ns = e(b)'
	}
		
		matrix define LEVEL_ns = LEVEL1_ns,LEVEL2_ns
		matrix nig12_ns=LEVEL_ns'

		matrix colnames nig12_ns = SR GPS Bias 
		matrix rownames nig12_ns = 1 2 

		matrix list nig12_ns

	foreach file in mlass nigeria {

	use "$`file'", clear 
	drop if bias_gps==. 

	forvalues i=3(1)6{
	mean SR_acres GPS_acres bias_gps if level_gps_acres==`i' & standard_unit==1
	matrix define LEVEL`i'_s = e(b)'
	mean SR_acres GPS_acres bias_gps if level_gps_acres==`i' & standard_unit==0
	matrix define LEVEL`i'_ns = e(b)'
	}
		mean SR_acres GPS_acres bias_gps if standard_unit==1
		matrix define LEVEL_TOT_s = e(b)'
		mean SR_acres GPS_acres bias_gps if standard_unit==0
		matrix define LEVEL_TOT_ns = e(b)'

		matrix define LEVEL_s = LEVEL3_s,LEVEL4_s,LEVEL5_s,LEVEL6_s,LEVEL_TOT_s
		matrix `file'_s=LEVEL_s'

		matrix colnames `file'_s = SR GPS Bias 
		matrix rownames `file'_s = 3 4 5 6 Total

		matrix list `file'_s

		matrix define LEVEL_ns = LEVEL3_ns,LEVEL4_ns,LEVEL5_ns,LEVEL6_ns,LEVEL_TOT_ns
		matrix `file'_ns=LEVEL_ns'

		matrix colnames `file'_ns = SR GPS Bias 
		matrix rownames `file'_ns = 3 4 5 6 Total

		matrix list `file'_ns
			
}
	
// Table 8: Determinants of Bias (GPS - CR)

use "$mlass", clear
	
	gen abs=abs(bias_cr)
	gen per=(bias_cr/CR_acre)*100
	gen abs_per=(abs/CR_acre)*100
	gen pa_cr=cr_perimeter/CRarea
	gen pa_gps=gps_perimeter/GPSarea
		replace pa_gps=pa_cr if pa_gps==. 

	foreach var in bias_cr  per abs_per {

	reg `var' CR_acres CR2 CR3 closingerr num_corners pa_gps num_satellite slope_clin i.treecover i.weather2, robust
	estimates store mlass_`var'
	
}
	reg abs CR_acres closingerr num_corners pa_gps num_satellite slope_clin i.treecover i.weather2 , robust
	estimates store mlass_abs
	
use "$zanzi", clear
	
	gen abs=abs(bias_cr)
	gen per=(bias_cr/CR_acre)*100
	gen abs_per=(abs/CR_acre)*100
	gen pa_cr=cr_perimeter/CRarea
	gen pa_gps=gps_perimeter/GPSarea
		replace pa_gps=pa_cr if pa_gps==. 
	
	foreach var in bias_cr abs  {

	reg `var' CR_acres closingerr num_corners pa_gps num_satellite i.treecover i.weather2, robust
	estimates store zanzi_`var'
		}
	
	reg per CR_acres CR2 closingerr num_corners pa_gps num_satellite i.treecover i.weather2, robust
	estimates store zanzi_per
	
	reg abs_per CR_acres CR2 closingerr num_corners pa_gps num_satellite i.treecover i.weather2, robust
	estimates store zanzi_abs_per
	
use "$nigeria", clear
	
	gen abs=abs(bias_cr)
	gen per=(bias_cr/CR_acre)*100
	gen abs_per=(abs/CR_acre)*100
	gen pa_cr=cr_perimeter/CRarea
	gen pa_gps=gps_perimeter/GPSarea
		replace pa_gps=pa_cr if pa_gps==. 

	foreach var in  abs  {

	reg `var' CR_acres CR2 closingerr num_corners pa_gps i.treecover i.weather2, robust
	estimates store nigeria_`var'
	
	}
	
	foreach var in bias_cr per abs_per {
	reg `var' CR_acres closingerr num_corners pa_gps i.treecover i.weather2, robust
	estimates store nigeria_`var'
	}

	
	estimates table mlass_bias_cr mlass_abs mlass_per mlass_abs_per zanzi_bias_cr zanzi_abs zanzi_per zanzi_abs_per ///
		nigeria_bias_cr nigeria_abs nigeria_per nigeria_abs_per,  stats(N r2) star(.10 .05 .01) b(%7.3f)

use "$all_exp", clear
	
	gen abs=abs(bias_cr)
	gen per=(bias_cr/CR_acre)*100
	gen abs_per=(abs/CR_acre)*100
	gen pa_cr=cr_perimeter/CRarea
	gen pa_gps=gps_perimeter/GPSarea
		replace pa_gps=pa_cr if pa_gps==. 

	reg bias_cr CR_acres CR2 closingerr num_corners pa_gps i.treecover i.weather2 i.survey, robust
	estimates store pool_bias_cr2
	
	reg abs CR_acres CR2 closingerr num_corners pa_gps i.treecover i.weather2 i.survey, robust
	estimates store pool_abs2
	
	foreach var in  per abs_per {

	reg `var' CR_acres CR2 CR3 closingerr num_corners pa_gps i.treecover i.weather2 i.survey, robust
	estimates store pool_`var'2
	
	}
	estimates table pool_bias_cr2 pool_abs2 pool_per2 pool_abs_per2,  stats(N r2) star(.10 .05 .01) b(%7.3f)

// Table 9: Determinants of High Bias
	
use "$mlass", clear
	
	gen pa_cr=cr_perimeter/CRarea
	gen pa_gps=gps_perimeter/GPSarea
		replace pa_gps=pa_cr if pa_gps==. // 2 changes
	gen highbias=(per_bias_cr>10 | per_bias_cr<-10)
	gen highbias_over=(highbias==1 & (GPS_acre>CR_acre))
	gen highbias_under=(highbias==1 & (GPS_acre<CR_acre))

	probit highbias CR_acres CR2 CR3 closingerr num_corners pa_gps num_satellite slope_clin i.treecover i.weather2, vce(cluster enum_id)
	margins, post dydx(*)
	estimates store mlass_highbias
	probit highbias_over CR_acres CR2 CR3 closingerr num_corners pa_gps num_satellite slope_clin i.treecover i.weather2, vce(cluster enum_id)
	margins, post dydx(*)
	estimates store mlass_over
	probit highbias_under CR_acres CR2 CR3 closingerr num_corners pa_gps num_satellite slope_clin i.treecover i.weather2, vce(cluster enum_id)
	margins, post dydx(*)
	estimates store mlass_under
	
use "$zanzi", clear
	
	gen pa_cr=cr_perimeter/CRarea
	gen pa_gps=gps_perimeter/GPSarea
			replace pa_gps=pa_cr if pa_gps==. // 11 changes
	gen highbias=(per_bias_cr>10 | per_bias_cr<-10)
	gen highbias_over=(highbias==1 & (GPS_acre>CR_acre))
	gen highbias_under=(highbias==1 & (GPS_acre<CR_acre))
	
	probit highbias CR_acres CR2 CR3 closingerr num_corners pa_gps num_satellite i.treecover i.weather2, vce(cluster enum_id)
	margins, post dydx(*)
	estimates store zanzi_highbias
	probit highbias_over CR_acres CR2 CR3 closingerr num_corners pa_gps num_satellite i.treecover i.weather2, vce(cluster enum_id)
	margins, post dydx(*)
	estimates store zanzi_over
	probit highbias_under CR_acres closingerr num_corners pa_gps num_satellite i.treecover i.weather2, vce(cluster enum_id)
	margins, post dydx(*)
	estimates store zanzi_under
	
use "$nigeria", clear
	
	gen pa_cr=cr_perimeter/CRarea
	gen pa_gps=gps_perimeter/GPSarea
				replace pa_gps=pa_cr if pa_gps==. // 0 changes
	gen highbias=(per_bias_cr>10 | per_bias_cr<-10)
	gen highbias_over=(highbias==1 & (GPS_acre>CR_acre))
	gen highbias_under=(highbias==1 & (GPS_acre<CR_acre))
	
	probit highbias CR_acres closingerr num_corners pa_gps i.treecover i.weather2, vce(cluster enum_id)
	margins, post dydx(*)
	estimates store nga_highbias
	probit highbias_over CR_acres CR2 CR3 closingerr num_corners pa_gps i.treecover i.weather2, vce(cluster enum_id)
	margins, post dydx(*)
	estimates store nga_over
	probit highbias_under CR_acres closingerr num_corners pa_gps i.treecover i.weather2, vce(cluster enum_id)
	margins, post dydx(*)
	estimates store nga_under
	
use "$all_exp", clear
	
	gen pa_cr=cr_perimeter/CRarea
	gen pa_gps=gps_perimeter/GPSarea
				replace pa_gps=pa_cr if pa_gps==. // 0 changes
	gen highbias=(per_bias_cr>10 | per_bias_cr<-10)
	gen highbias_over=(highbias==1 & (GPS_acre>CR_acre))
	gen highbias_under=(highbias==1 & (GPS_acre<CR_acre))
	
	probit highbias CR_acres CR2 CR3 closingerr num_corners pa_gps i.treecover i.weather2 i.survey, vce(cluster enum_id)
	margins, post dydx(*)
	estimates store pool_highbias2
	probit highbias_over CR_acres CR2 CR3 closingerr num_corners pa_gps i.treecover i.weather2 i.survey, vce(cluster enum_id)
	margins, post dydx(*)
	estimates store pool_over2
	probit highbias_under CR_acres CR2 CR3 closingerr num_corners pa_gps i.treecover i.weather2 i.survey, vce(cluster enum_id)
	margins, post dydx(*)
	estimates store pool_under2
			
	estimates table mlass_highbias mlass_over mlass_under zanzi_highbias zanzi_over zanzi_under nga_highbias ///
		nga_over nga_under pool_highbias2 pool_over2 pool_under2, stats(N) star(.10 .05 .01) b(%7.3f)

		
// Table A1: Summary Statistics on Weather Conditions, Satellites, & Canopy Cover

	// Weather Conditions
	foreach file in mlass zanzi all_exp {

	use "$`file'", clear 
	drop if weather==. | bias_cr==.

	forvalues i=1(1)6{
	mean GPS_acres CR_acres bias_cr if weather==`i'
	matrix define LEVEL`i' = e(b)'
	}
		mean GPS_acres CR_acres bias_cr
		matrix define LEVEL_TOT = e(b)'

		matrix define LEVEL = LEVEL1,LEVEL2,LEVEL3,LEVEL4,LEVEL5,LEVEL6,LEVEL_TOT
		matrix `file'=LEVEL'

		matrix colnames `file' = GPS CR BIAS
		matrix rownames `file' = 1 2 3 4 5 6 Total

		matrix list `file'
}
		*Nigeria missing some weather conditions
		use "$nigeria", clear 
		drop if weather==. | bias_cr==.
		drop if weather==6 // 1 obs only

		forvalues i=1(1)4{
		mean GPS_acres CR_acres bias_cr if weather==`i'
		matrix define LEVEL`i' = e(b)'
		}
		mean GPS_acres CR_acres bias_cr
		matrix define LEVEL_TOT = e(b)'

		matrix define LEVEL = LEVEL1,LEVEL2,LEVEL3,LEVEL4
		matrix nigeria=LEVEL'
		matrix nigeria_tot=LEVEL_TOT'

		matrix colnames nigeria = GPS CR BIAS
		matrix rownames nigeria = 1 2 3 4 

		matrix list nigeria
		
	//Satellite Aquisition
	foreach file in mlass zanzi {

	use "$`file'", clear 
	drop if level_sat==. | bias_cr==.

	forvalues i=1(1)3{
	mean GPS_acres CR_acres bias_cr if level_sat==`i'
	matrix define LEVEL`i' = e(b)'
	}
		mean GPS_acres CR_acres bias_cr
		matrix define LEVEL_TOT = e(b)'

		matrix define LEVEL = LEVEL1,LEVEL2,LEVEL3,LEVEL_TOT
		matrix `file'=LEVEL'

		matrix colnames `file' = GPS CR BIAS
		matrix rownames `file' = 1 2 3 Total

		matrix list `file'
}		
	// Canopy Cover
	foreach file in mlass zanzi nigeria all_exp {

	use "$`file'", clear 
	drop if treecover==. | bias_cr==.

	forvalues i=1(1)3{
	mean GPS_acres CR_acres bias_cr if treecover==`i'
	matrix define LEVEL`i' = e(b)'
	}
		mean GPS_acres CR_acres bias_cr
		matrix define LEVEL_TOT = e(b)'

		matrix define LEVEL = LEVEL1,LEVEL2,LEVEL3,LEVEL_TOT
		matrix `file'=LEVEL'

		matrix colnames `file' = GPS CR BIAS
		matrix rownames `file' = 1 2 3 Total

		matrix list `file'
}
